/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameType;

public class SPlayerListItemPacket
implements IPacket<IClientPlayNetHandler> {
    private Action field_179770_a;
    private final List<AddPlayerData> field_179769_b = Lists.newArrayList();

    public SPlayerListItemPacket() {
    }

    public SPlayerListItemPacket(Action action, ServerPlayerEntity ... serverPlayerEntityArray) {
        this.field_179770_a = action;
        for (ServerPlayerEntity serverPlayerEntity : serverPlayerEntityArray) {
            this.field_179769_b.add(new AddPlayerData(serverPlayerEntity.func_146103_bH(), serverPlayerEntity.field_71138_i, serverPlayerEntity.field_71134_c.func_73081_b(), serverPlayerEntity.func_175396_E()));
        }
    }

    public SPlayerListItemPacket(Action action, Iterable<ServerPlayerEntity> iterable) {
        this.field_179770_a = action;
        for (ServerPlayerEntity serverPlayerEntity : iterable) {
            this.field_179769_b.add(new AddPlayerData(serverPlayerEntity.func_146103_bH(), serverPlayerEntity.field_71138_i, serverPlayerEntity.field_71134_c.func_73081_b(), serverPlayerEntity.func_175396_E()));
        }
    }

    @Override
    public void func_148837_a(PacketBuffer packetBuffer2) throws IOException {
        this.field_179770_a = packetBuffer2.func_179257_a(Action.class);
        int n = packetBuffer2.func_150792_a();
        for (\u2603 = 0; \u2603 < n; ++\u2603) {
            GameProfile \u26035 = null;
            int \u26032 = 0;
            GameType \u26033 = null;
            ITextComponent \u26034 = null;
            switch (this.field_179770_a) {
                case ADD_PLAYER: {
                    PacketBuffer packetBuffer2;
                    \u26035 = new GameProfile(packetBuffer2.func_179253_g(), packetBuffer2.func_150789_c(16));
                    int n2 = packetBuffer2.func_150792_a();
                    for (\u2603 = 0; \u2603 < n2; ++\u2603) {
                        String string = packetBuffer2.func_150789_c(Short.MAX_VALUE);
                        \u2603 = packetBuffer2.func_150789_c(Short.MAX_VALUE);
                        if (packetBuffer2.readBoolean()) {
                            \u26035.getProperties().put((Object)string, (Object)new Property(string, \u2603, packetBuffer2.func_150789_c(Short.MAX_VALUE)));
                            continue;
                        }
                        \u26035.getProperties().put((Object)string, (Object)new Property(string, \u2603));
                    }
                    \u26033 = GameType.func_77146_a(packetBuffer2.func_150792_a());
                    \u26032 = packetBuffer2.func_150792_a();
                    if (!packetBuffer2.readBoolean()) break;
                    \u26034 = packetBuffer2.func_179258_d();
                    break;
                }
                case UPDATE_GAME_MODE: {
                    PacketBuffer packetBuffer2;
                    \u26035 = new GameProfile(packetBuffer2.func_179253_g(), null);
                    \u26033 = GameType.func_77146_a(packetBuffer2.func_150792_a());
                    break;
                }
                case UPDATE_LATENCY: {
                    \u26035 = new GameProfile(packetBuffer2.func_179253_g(), null);
                    \u26032 = packetBuffer2.func_150792_a();
                    break;
                }
                case UPDATE_DISPLAY_NAME: {
                    \u26035 = new GameProfile(packetBuffer2.func_179253_g(), null);
                    if (!packetBuffer2.readBoolean()) break;
                    \u26034 = packetBuffer2.func_179258_d();
                    break;
                }
                case REMOVE_PLAYER: {
                    \u26035 = new GameProfile(packetBuffer2.func_179253_g(), null);
                }
            }
            this.field_179769_b.add(new AddPlayerData(\u26035, \u26032, \u26033, \u26034));
        }
    }

    @Override
    public void func_148840_b(PacketBuffer packetBuffer2) throws IOException {
        packetBuffer2.func_179249_a(this.field_179770_a);
        packetBuffer2.func_150787_b(this.field_179769_b.size());
        for (AddPlayerData addPlayerData : this.field_179769_b) {
            switch (this.field_179770_a) {
                case ADD_PLAYER: {
                    PacketBuffer packetBuffer2;
                    packetBuffer2.func_179252_a(addPlayerData.func_179962_a().getId());
                    packetBuffer2.func_180714_a(addPlayerData.func_179962_a().getName());
                    packetBuffer2.func_150787_b(addPlayerData.func_179962_a().getProperties().size());
                    for (Property property : addPlayerData.func_179962_a().getProperties().values()) {
                        packetBuffer2.func_180714_a(property.getName());
                        packetBuffer2.func_180714_a(property.getValue());
                        if (property.hasSignature()) {
                            packetBuffer2.writeBoolean(true);
                            packetBuffer2.func_180714_a(property.getSignature());
                            continue;
                        }
                        packetBuffer2.writeBoolean(false);
                    }
                    packetBuffer2.func_150787_b(addPlayerData.func_179960_c().func_77148_a());
                    packetBuffer2.func_150787_b(addPlayerData.func_179963_b());
                    if (addPlayerData.func_179961_d() == null) {
                        packetBuffer2.writeBoolean(false);
                        break;
                    }
                    packetBuffer2.writeBoolean(true);
                    packetBuffer2.func_179256_a(addPlayerData.func_179961_d());
                    break;
                }
                case UPDATE_GAME_MODE: {
                    PacketBuffer packetBuffer2;
                    packetBuffer2.func_179252_a(addPlayerData.func_179962_a().getId());
                    packetBuffer2.func_150787_b(addPlayerData.func_179960_c().func_77148_a());
                    break;
                }
                case UPDATE_LATENCY: {
                    PacketBuffer packetBuffer2;
                    packetBuffer2.func_179252_a(addPlayerData.func_179962_a().getId());
                    packetBuffer2.func_150787_b(addPlayerData.func_179963_b());
                    break;
                }
                case UPDATE_DISPLAY_NAME: {
                    PacketBuffer packetBuffer2;
                    packetBuffer2.func_179252_a(addPlayerData.func_179962_a().getId());
                    if (addPlayerData.func_179961_d() == null) {
                        packetBuffer2.writeBoolean(false);
                        break;
                    }
                    packetBuffer2.writeBoolean(true);
                    packetBuffer2.func_179256_a(addPlayerData.func_179961_d());
                    break;
                }
                case REMOVE_PLAYER: {
                    PacketBuffer packetBuffer2;
                    packetBuffer2.func_179252_a(addPlayerData.func_179962_a().getId());
                }
            }
        }
    }

    @Override
    public void func_148833_a(IClientPlayNetHandler iClientPlayNetHandler) {
        iClientPlayNetHandler.func_147256_a(this);
    }

    public List<AddPlayerData> func_179767_a() {
        return this.field_179769_b;
    }

    public Action func_179768_b() {
        return this.field_179770_a;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("action", (Object)this.field_179770_a).add("entries", this.field_179769_b).toString();
    }

    public class AddPlayerData {
        private final int field_179966_b;
        private final GameType field_179967_c;
        private final GameProfile field_179964_d;
        private final ITextComponent field_179965_e;

        public AddPlayerData(GameProfile gameProfile, int n, @Nullable GameType gameType, @Nullable ITextComponent iTextComponent) {
            this.field_179964_d = gameProfile;
            this.field_179966_b = n;
            this.field_179967_c = gameType;
            this.field_179965_e = iTextComponent;
        }

        public GameProfile func_179962_a() {
            return this.field_179964_d;
        }

        public int func_179963_b() {
            return this.field_179966_b;
        }

        public GameType func_179960_c() {
            return this.field_179967_c;
        }

        @Nullable
        public ITextComponent func_179961_d() {
            return this.field_179965_e;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("latency", this.field_179966_b).add("gameMode", (Object)this.field_179967_c).add("profile", (Object)this.field_179964_d).add("displayName", this.field_179965_e == null ? null : ITextComponent.Serializer.func_150696_a(this.field_179965_e)).toString();
        }
    }

    public static enum Action {
        ADD_PLAYER,
        UPDATE_GAME_MODE,
        UPDATE_LATENCY,
        UPDATE_DISPLAY_NAME,
        REMOVE_PLAYER;

    }
}

